
#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <fcntl.h>
#include <sys/ioctl.h>

#include "trackerpod-ioctl.h"

int main(int argc, char *argv[])
{
  struct trackerpod_posn p;
  int fd, opt, shutdown = 0;
  
  while ((opt = getopt(argc, argv, "s")) != -1)
  {
    switch (opt)
    {
	    case 's':
		    shutdown = 1;
		    break;

	    default:
		    fprintf(stderr, "FUBAR\n");
		    return 1;
    }
  }

  if (argc - optind != 2)
  {
    fprintf(stderr, "Yo momma\n");
    return 1;
  }

  p.pan = atoi(argv[optind]);
  p.tilt = atoi(argv[optind + 1]);

  if ((fd = open("/dev/usb/tpod0", O_RDWR)) < 0)
  {
    perror("open");
    return 1;
  }

  if (ioctl(fd, TRACKERPOD_IOCSPOSN, &p) < 0)
  {
    perror("ioctl");
    close(fd);
    return 1;
  }

  if (shutdown && ioctl(fd, TRACKERPOD_IOCSHCL, NULL) < 0)
  {
    perror("ioctl 2");
    close(fd);
    return 1;
  }

  close(fd);
  return 0;
}
