
#include <stdio.h>
#include <stdlib.h>
#include <errno.h>
#include <syslog.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <arpa/inet.h>

#include "common.h"
#include "in.ipscrompd.h"

#ifndef FW_DIRECTORY
#error You must define FW_DIRECTORY for fw_touch.c
#endif

int fw_add_ip(struct in_addr ip, char *user)
{
  FILE *fp;

  /* 21 includes 19 byes for the IP, a slash and a NULL */
  char *path = malloc(strlen(FW_DIRECTORY) + 21);

  if (path == NULL)
  {
    syslog(LOG_ERR, "malloc failed in fw_touch.c");
    return -ENOMEM;
  }

  sprintf(path, "%s/%s", FW_DIRECTORY, inet_ntoa(ip));

  if ((fp = fopen(path, "w")) == NULL)
  {
    syslog(LOG_ERR, "Unable to open '%s': %m", path);
    free(path);
    return -errno;
  }

  fprintf(fp, "%s\n", user);
  fclose(fp);
  free(path);

  return 0;
}
