
#include <stdio.h>
#include <stdlib.h>
#include <errno.h>
#include <unistd.h>
#include <syslog.h>
#include <string.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <sys/wait.h>
#include <netinet/in.h>
#include <arpa/inet.h>

#include "common.h"
#include "in.ipscrompd.h"

#ifndef FW_PROGRAM
#error You must define FW_PROGRAM for fw_program.c
#endif

int run_cmd(char *argv[]);

int fw_add_ip(struct in_addr ip, char *user)
{
  char *command[] = { FW_PROGRAM, inet_ntoa(ip), user, NULL};
  int rc;

  if ((rc = run_cmd(command)) < 0)
  {
    syslog(LOG_ERR, "Error while executing '%s %s': %d (%s)\n",
		    command[0], command[1], rc, strerror(-rc));
  }

  return rc;
}

/* because system() is borked */
int run_cmd(char *argv[])
{
  pid_t pid;
  int status;
  
  pid = fork();
  if (pid < 0)
  {
    /* fork() failed */
    return -1;
  }
  else if (pid == 0) 
  {
    /* Child process */

    /* argv[0] is the full path to our prog */
    /* Use that as the 1st arg to execv()   */
    /* Then, use the shortname for argv[0]  */
   
    char *progpath = argv[0];
    argv[0] = progname(argv[0]);
    
    fclose(stdin);
    fclose(stdout);  /* don't want errors going to the client! */
    fclose(stderr);
    
    execv(progpath, argv);

    /* NOTREACHED */
    /* Brian uses _exit(). Why? */
    exit(errno);
  }

  /* wait for a valid exit code */
  while (wait(&status) < 0);

  if (WIFEXITED(status))
  {
    /* If the program exitted, use its exit status */
    status = -WEXITSTATUS(status);
  }
  else
  {
    /* Otherwise, just blag it... */
    status = -256;
  }

  return status;
}
